import {
  async,
  TestBed,
} from "@angular/core/testing";
import {RouterTestingModule} from "@angular/router/testing";
import {
  AppModule,
  appModuleState,
} from "@app/app.module";
import {environment} from "@environments/environment";
import {NgxsModule} from "@ngxs/store";
import {ENVIRONMENT} from "solidify-frontend";
import {AppComponent} from "./app.component";

describe("AppComponent", () => {
  beforeEach(async(() => {
    TestBed.configureTestingModule({
      imports: [
        RouterTestingModule,
        NgxsModule.forRoot([
          ...appModuleState,
        ]),
        AppModule,
      ],
      providers: [
        {
          provide: ENVIRONMENT,
          useValue: environment,
        },
      ],
    }).compileComponents();
  }));

  xit("should create the app", () => {
    const fixture = TestBed.createComponent(AppComponent);
    const app = fixture.componentInstance;
    expect(app).toBeTruthy();
  });

  xit(`should have a title not empty`, () => {
    const fixture = TestBed.createComponent(AppComponent);
    const app = fixture.componentInstance;
    expect(app.getTitle()).not.toBe("");
  });

  xit("should render image with unige logo", () => {
    const fixture = TestBed.createComponent(AppComponent);
    fixture.detectChanges();
    const compiled = fixture.nativeElement;
    expect(compiled.querySelector("div.logo>img").src).toContain("unigelogo-white.svg");
  });
});
