import {NgModule} from "@angular/core";
import {RouterModule} from "@angular/router";
import {PageNotFoundPresentational} from "@app/components/presentationals/page-not-found/page-not-found.presentational";
import {IconAppRoutable} from "@app/components/routables/icon-app/icon-app.routable";
import {MaintenanceModeRoutable} from "@app/components/routables/maintenance-mode/maintenance-mode.routable";
import {ServerOfflineModeRoutable} from "@app/components/routables/server-offline-mode/server-offline-mode.routable";
import {ApplicationRolePermissionEnum} from "@app/shared/enums/application-role-permission.enum";
import {AppRoutesEnum} from "@app/shared/enums/routes.enum";
import {ApplicationRoleGuardService} from "@app/shared/guards/application-role-guard.service";
import {DlcmRoutes} from "@app/shared/models/dlcm-route.model";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {ApplicationDevGuardService} from "@shared/guards/application-dev-guard.service";
import {ApplicationMaintenanceGuardService} from "@shared/guards/application-maintenance-guard.service";
import {PreventLeaveGuardService} from "@shared/guards/prevent-leave-guard.service";
import {UrlQueryParamHelper} from "@shared/helpers/url-query-param.helper";

const routes: DlcmRoutes = [
  {
    path: AppRoutesEnum.home,
    // @ts-ignore Dynamic import
    loadChildren: () => import("./features/home/home.module").then(m => m.HomeModule),
    data: {
      permission: ApplicationRolePermissionEnum.noPermission,
    },
    canActivate: [ApplicationMaintenanceGuardService, ApplicationRoleGuardService],
  },
  {
    path: AppRoutesEnum.deposit,
    // @ts-ignore Dynamic import
    loadChildren: () => import("./features/deposit/deposit.module").then(m => m.DepositModule),
    data: {
      breadcrumb: LabelTranslateEnum.deposit,
      permission: ApplicationRolePermissionEnum.userPermission,
    },
    canActivate: [ApplicationMaintenanceGuardService, ApplicationRoleGuardService],
  },
  {
    path: AppRoutesEnum.preservationSpace,
    // @ts-ignore Dynamic import
    loadChildren: () => import("./features/preservation-space/preservation-space.module").then(m => m.PreservationSpaceModule),
    data: {
      breadcrumb: LabelTranslateEnum.preservationSpace,
      permission: ApplicationRolePermissionEnum.userPermission,
    },
    canActivate: [ApplicationMaintenanceGuardService, ApplicationRoleGuardService],
  },
  {
    path: AppRoutesEnum.admin,
    // @ts-ignore Dynamic import
    loadChildren: () => import("./features/admin/admin.module").then(m => m.AdminModule),
    data: {
      breadcrumb: LabelTranslateEnum.administration,
      permission: ApplicationRolePermissionEnum.adminPermission,
    },
    canActivate: [ApplicationMaintenanceGuardService, ApplicationRoleGuardService],
  },
  {
    path: AppRoutesEnum.preservationPlanning,
    // @ts-ignore Dynamic import
    loadChildren: () => import("@preservation-planning/preservation-planning.module").then(m => m.PreservationPlanningModule),
    data: {
      breadcrumb: LabelTranslateEnum.preservationPlanning,
      permission: ApplicationRolePermissionEnum.adminPermission,
    },
    canActivate: [ApplicationMaintenanceGuardService, ApplicationRoleGuardService],
  },
  {
    path: AppRoutesEnum.order,
    // @ts-ignore Dynamic import
    loadChildren: () => import("./features/order/order.module").then(m => m.OrderModule),
    data: {
      breadcrumb: LabelTranslateEnum.archiveOrders,
      permission: ApplicationRolePermissionEnum.userPermission,
    },
    canActivate: [ApplicationMaintenanceGuardService, ApplicationRoleGuardService],
  },
  {
    path: AppRoutesEnum.icons,
    component: IconAppRoutable,
    canActivate: [ApplicationDevGuardService],
  },
  {
    path: AppRoutesEnum.maintenance,
    component: MaintenanceModeRoutable,
    canDeactivate: [PreventLeaveGuardService],
  },
  {
    path: AppRoutesEnum.serverOffline,
    component: ServerOfflineModeRoutable,
    canDeactivate: [PreventLeaveGuardService],
  },
  {
    path: AppRoutesEnum.root,
    redirectTo: "/" + AppRoutesEnum.home + UrlQueryParamHelper.getQueryParamOAuth2(),
    pathMatch: "full",
    canActivate: [ApplicationMaintenanceGuardService],
  },
  {
    path: AppRoutesEnum.index,
    redirectTo: "/" + AppRoutesEnum.home + UrlQueryParamHelper.getQueryParamOAuth2(),
    pathMatch: "full",
    canActivate: [ApplicationMaintenanceGuardService],
  },
  {
    path: "**",
    component: PageNotFoundPresentational,
  },
];

@NgModule({
  imports: [RouterModule.forRoot(routes, {
    useHash: true,
  })],
  exports: [RouterModule],
})
export class AppRoutingModule {
}
