import {NgModule} from "@angular/core";
import {SharedModule} from "@app/shared/shared.module";
import {TranslateModule} from "@ngx-translate/core";
import {NgxsModule} from "@ngxs/store";
import {AdminUserState} from "@admin/user/stores/admin-user.state";
import {AdminUserRoutingModule} from "@admin/user/user-routing.module";
import {AdminUserListRoutable} from "@admin/user/components/routables/list/admin-user-list-routable";
import {AdminUserDetailRoutable} from "@admin/user/components/routables/detail/admin-user-detail.routable";
import {AdminUserCreateRoutable} from "@admin/user/components/routables/create/admin-user-create.routable";
import {AdminUserEditRoutable} from "@admin/user/components/routables/edit/admin-user-edit.routable";
import {AdminUserDeleteDialog} from "@admin/user/components/dialogs/admin-user-delete.dialog";
import {AdminUserForm} from "@admin/user/components/presentationals/admin-user-form";

const routables = [
  AdminUserListRoutable,
  AdminUserDetailRoutable,
  AdminUserCreateRoutable,
  AdminUserEditRoutable
];
const containers = [];
const dialogs = [
  AdminUserDeleteDialog
];
const presentationals = [
  AdminUserForm
];

@NgModule({
  declarations: [
    ...routables,
    ...containers,
    ...dialogs,
    ...presentationals,
  ],
  imports: [
    SharedModule,
    AdminUserRoutingModule,
    TranslateModule.forChild({}),
    NgxsModule.forFeature([
      AdminUserState
    ]),
  ],
  entryComponents: [
    ...dialogs,
  ],
  exports: [
    ...routables,
  ],
  providers: [],
})
export class AdminUserModule { }
