import {NgModule} from "@angular/core";
import {RouterModule, Routes} from "@angular/router";
import {AdminRoutesEnum, AppRoutesEnum} from "@shared/enums/routes.enum";
import {TRANSLATE} from "solidify-frontend";
import {AdminUserListRoutable} from "@admin/user/components/routables/list/admin-user-list-routable";
import {ApplicationRolePermissionEnum} from "@shared/enums/application-role-permission.enum";
import {ApplicationRoleGuardService} from "@shared/guards/application-role-guard.service";
import {AdminUserDetailRoutable} from "@admin/user/components/routables/detail/admin-user-detail.routable";
import {AdminUserCreateRoutable} from "@admin/user/components/routables/create/admin-user-create.routable";
import {AdminUserEditRoutable} from "@admin/user/components/routables/edit/admin-user-edit.routable";

const routes: Routes = [
  {
    path: AppRoutesEnum.root,
    component: AdminUserListRoutable,
    data: {
      breadcrumb: TRANSLATE("breadcrumb.admin.user.list"),
      permission: ApplicationRolePermissionEnum.rootPermission,
    },
    canActivate: [ApplicationRoleGuardService],
  },
  {
    path: AdminRoutesEnum.userDetail + AppRoutesEnum.separator + AppRoutesEnum.paramId,
    component: AdminUserDetailRoutable,
    data: {
      breadcrumb: TRANSLATE("breadcrumb.admin.user.detail"),
      permission: ApplicationRolePermissionEnum.rootPermission,
    },
  },
  {
    path: AdminRoutesEnum.userCreate,
    component: AdminUserCreateRoutable,
    data: {
      breadcrumb: TRANSLATE("breadcrumb.admin.user.create"),
    },
  },
  {
    path: AdminRoutesEnum.userEdit + AppRoutesEnum.separator + AppRoutesEnum.paramId,
    component: AdminUserEditRoutable,
    data: {
      breadcrumb: TRANSLATE("breadcrumb.admin.user.edit"),
    },
  },

];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class AdminUserRoutingModule { }
