import {AdminUserAction, adminUserActionNameSpace,} from "@admin/user/stores/admin-user.action";
import {AdminResourceApiEnum} from "@shared/enums/api.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {RoutesEnum} from "@shared/enums/routes.enum";
import {SharedOrgUnitAction} from "@shared/stores/organizational-unit/shared-organizational-unit.action";
import {SharedPersonAction} from "@shared/stores/person/shared-person.action";
import {Action, Actions, State, StateContext, Store,} from "@ngxs/store";
import {UserExtended} from "@shared/models/business/user-extended.model";
import {
  ApiService,
  defaultResourceStateInitValue,
  NotificationService,
  ResourceState,
  ResourceStateModel,
  TRANSLATE,
} from "solidify-frontend";

export interface AdminUserStateModel extends ResourceStateModel<UserExtended> {
}

@State<AdminUserStateModel>({
  name: LocalStateEnum.admin_user,
  defaults: {
    ...defaultResourceStateInitValue,
  },

})
export class AdminUserState extends ResourceState<UserExtended> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: adminUserActionNameSpace,
      urlResource: AdminResourceApiEnum.users,
      routeRedirectUrlAfterSuccessAction: RoutesEnum.adminUser,
      notificationResourceCreateTextToTranslate: TRANSLATE("admin.user.notification.resource.create"),
      notificationResourceDeleteTextToTranslate: TRANSLATE("admin.user.notification.resource.delete"),
      notificationResourceUpdateTextToTranslate: TRANSLATE("admin.user.notification.resource.update"),
    });
  }

  @Action(AdminUserAction.LoadResource)
  loadResource(ctx: StateContext<AdminUserStateModel>, action: AdminUserAction.LoadResource): void {
    ctx.patchState({
      isLoadingCounter: ctx.getState().isLoadingCounter + 1,
    });

    ctx.dispatch([
      new SharedPersonAction.GetAll(),
      new SharedOrgUnitAction.GetAll(),
      new AdminUserAction.LoadResourceSuccess(action),
    ]);
  }

  @Action(AdminUserAction.LoadResourceSuccess)
  loadResourceSuccess(ctx: StateContext<AdminUserStateModel>, action: AdminUserAction.LoadResourceSuccess): void {
    ctx.patchState({
      isLoadingCounter: ctx.getState().isLoadingCounter - 1,
    });
  }

  @Action(AdminUserAction.LoadResourceFail)
  loadResourceFail(ctx: StateContext<AdminUserStateModel>, action: AdminUserAction.LoadResourceFail): void {
    ctx.patchState({
      isLoadingCounter: ctx.getState().isLoadingCounter - 1,
    });
  }
}
