import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {UserExtended} from "@shared/models/business/user-extended.model";
import {ResourceAction, ResourceNameSpace, TypeDefaultAction,} from "solidify-frontend";

const state = LocalStateEnum.admin_user;

export namespace AdminUserAction {
  @TypeDefaultAction(state)
  export class LoadResource extends ResourceAction.LoadResource {
  }

  @TypeDefaultAction(state)
  export class LoadResourceSuccess extends ResourceAction.LoadResourceSuccess {
  }

  @TypeDefaultAction(state)
  export class LoadResourceFail extends ResourceAction.LoadResourceFail {
  }

  @TypeDefaultAction(state)
  export class ChangeQueryParameters extends ResourceAction.ChangeQueryParameters {
  }

  @TypeDefaultAction(state)
  export class GetAll extends ResourceAction.GetAll {
  }

  @TypeDefaultAction(state)
  export class GetAllSuccess extends ResourceAction.GetAllSuccess<UserExtended> {
  }

  @TypeDefaultAction(state)
  export class GetAllFail extends ResourceAction.GetAllFail<UserExtended> {
  }

  @TypeDefaultAction(state)
  export class GetById extends ResourceAction.GetById {
  }

  @TypeDefaultAction(state)
  export class GetByIdSuccess extends ResourceAction.GetByIdSuccess<UserExtended> {
  }

  @TypeDefaultAction(state)
  export class GetByIdFail extends ResourceAction.GetByIdFail<UserExtended> {
  }

  @TypeDefaultAction(state)
  export class Create extends ResourceAction.Create<UserExtended> {
  }

  @TypeDefaultAction(state)
  export class CreateSuccess extends ResourceAction.CreateSuccess<UserExtended> {
  }

  @TypeDefaultAction(state)
  export class CreateFail extends ResourceAction.CreateFail<UserExtended> {
  }

  @TypeDefaultAction(state)
  export class Update extends ResourceAction.Update<UserExtended> {
  }

  @TypeDefaultAction(state)
  export class UpdateSuccess extends ResourceAction.UpdateSuccess<UserExtended> {
  }

  @TypeDefaultAction(state)
  export class UpdateFail extends ResourceAction.UpdateFail<UserExtended> {
  }

  @TypeDefaultAction(state)
  export class Delete extends ResourceAction.Delete {
  }

  @TypeDefaultAction(state)
  export class DeleteSuccess extends ResourceAction.DeleteSuccess {
  }

  @TypeDefaultAction(state)
  export class DeleteFail extends ResourceAction.DeleteFail {
  }
}

export const adminUserActionNameSpace: ResourceNameSpace = AdminUserAction;
