import {ChangeDetectionStrategy, Component,} from "@angular/core";
import {adminUserActionNameSpace} from "@admin/user/stores/admin-user.action";
import {AdminUserStateModel} from "@admin/user/stores/admin-user.state";
import {SharedAbstractListRoutable} from "@shared/components/routables/shared-abstract-list/shared-abstract-list.routable";
import {FieldTypeEnum} from "@shared/enums/field-type.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {Store} from "@ngxs/store";
import {UserExtended} from "@shared/models/business/user-extended.model";
import {TRANSLATE} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-user-list-routable",
  templateUrl: "../../../../../../shared/components/routables/shared-abstract-list/shared-abstract-list.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-list/shared-abstract-list.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminUserListRoutable extends SharedAbstractListRoutable<UserExtended, AdminUserStateModel> {
  readonly KEY_CREATE_BUTTON: string = TRANSLATE("admin.user.button.new");
  readonly KEY_REFRESH_BUTTON: string = TRANSLATE("admin.user.button.refresh");

  constructor(protected store: Store) {
    super(store, LocalStateEnum.admin_user, adminUserActionNameSpace, {}, LocalStateEnum.admin);
  }

  defineColumns(): void {
    this.columns = [
      {
        field: "externalUid",
        header: TRANSLATE("admin.user.table.header.externalUid"),
        type: FieldTypeEnum.string,
        order: 0,
        isFilterable: true,
        isSortable: true,
      },
      {
        field: "targetedUid",
        header: TRANSLATE("admin.user.table.header.targetedUid"),
        type: FieldTypeEnum.string,
        order: 0,
        isFilterable: true,
        isSortable: true,
      },
      {
        field: "firstName",
        header: TRANSLATE("admin.user.table.header.firstName"),
        type: FieldTypeEnum.string,
        order: 0,
        isFilterable: true,
        isSortable: true,
      },
      {
        field: "lastName",
        header: TRANSLATE("admin.user.table.header.lastName"),
        type: FieldTypeEnum.string,
        order: 0,
        isFilterable: true,
        isSortable: true,
      },
      {
        field: "homeOrganization",
        header: TRANSLATE("admin.user.table.header.homeOrganization"),
        type: FieldTypeEnum.string,
        order: 0,
        isFilterable: true,
        isSortable: true,
      },
      {
        field: "email",
        header: TRANSLATE("admin.user.table.header.email"),
        type: FieldTypeEnum.string,
        order: 0,
        isFilterable: true,
        isSortable: true,
      },
    ];
  }
}
