import {ChangeDetectionStrategy, Component,} from "@angular/core";
import {ActivatedRoute} from "@angular/router";
import {adminUserActionNameSpace} from "@admin/user/stores/admin-user.action";
import {AdminUserStateModel} from "@admin/user/stores/admin-user.state";
import {AccessOrganizationalUnit, Person,} from "@app/generated-api";
import {SharedAbstractEditRoutable} from "@shared/components/routables/shared-abstract-edit/shared-abstract-edit.routable";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {LocalStateModel} from "@shared/models/local-state.model";
import {Select, Store,} from "@ngxs/store";
import {UserExtended} from "@shared/models/business/user-extended.model";
import {Observable} from "rxjs";

@Component({
  selector: "dlcm-admin-user-edit-routable",
  templateUrl: "./admin-user-edit.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-edit/shared-abstract-edit.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminUserEditRoutable extends SharedAbstractEditRoutable<UserExtended, AdminUserStateModel> {
  @Select((state: LocalStateModel) => state.shared.shared_person.list) listPersonObs: Observable<Person[]>;
  @Select((state: LocalStateModel) => state.shared.shared_organizationalUnit.list) listOrgUnitObs: Observable<AccessOrganizationalUnit[]>;

  constructor(protected store: Store,
              protected route: ActivatedRoute) {
    super(store, route, LocalStateEnum.admin_user, adminUserActionNameSpace, LocalStateEnum.admin);
  }

  getSubResourceWithParentId(id: string): void {
  }
}
