import {ChangeDetectionStrategy, Component,} from "@angular/core";
import {MatDialog} from "@angular/material";
import {ActivatedRoute} from "@angular/router";
import {adminUserActionNameSpace} from "@admin/user/stores/admin-user.action";
import {AdminUserStateModel} from "@admin/user/stores/admin-user.state";
import {AccessOrganizationalUnit, Person,} from "@app/generated-api";
import {SharedAbstractDetailRoutable} from "@shared/components/routables/shared-abstract-detail/shared-abstract-detail.routable";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {LocalStateModel} from "@shared/models/local-state.model";
import {Select, Store,} from "@ngxs/store";
import {UserExtended} from "@shared/models/business/user-extended.model";
import {Observable} from "rxjs";
import {TRANSLATE} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-user-detail-routable",
  templateUrl: "./admin-user-detail.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-detail/shared-abstract-detail.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminUserDetailRoutable extends SharedAbstractDetailRoutable<UserExtended, AdminUserStateModel> {
  @Select((state: LocalStateModel) => state.shared.shared_person.list) listPersonObs: Observable<Person[]>;
  @Select((state: LocalStateModel) => state.shared.shared_organizationalUnit.list) listOrgUnitObs: Observable<AccessOrganizationalUnit[]>;

  readonly KEY_DELETE_BUTTON: string = TRANSLATE("admin.user.button.delete");
  readonly KEY_EDIT_BUTTON: string = TRANSLATE("admin.user.button.edit");
  readonly KEY_PARAM_NAME: string = "externalUid";

  constructor(protected store: Store,
              protected route: ActivatedRoute,
              public dialog: MatDialog) {
    super(store, route, dialog, LocalStateEnum.admin_user, adminUserActionNameSpace, LocalStateEnum.admin);
  }

  getSubResourceWithParentId(id: string): void {
  }
}
