import {ChangeDetectionStrategy, Component, ViewChild,} from "@angular/core";
import {adminUserActionNameSpace} from "@admin/user/stores/admin-user.action";
import {AdminUserStateModel} from "@admin/user/stores/admin-user.state";
import {AccessOrganizationalUnit, Person,} from "@app/generated-api";
import {SharedAbstractFormPresentational} from "@shared/components/presentationals/shared-abstract-form/shared-abstract-form.presentational";
import {SharedAbstractCreateRoutable} from "@shared/components/routables/shared-abstract-create/shared-abstract-create.routable";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {LocalStateModel} from "@shared/models/local-state.model";
import {Select, Store,} from "@ngxs/store";
import {UserExtended} from "@shared/models/business/user-extended.model";
import {Observable} from "rxjs";

@Component({
  selector: "dlcm-admin-user-create-routable",
  templateUrl: "./admin-user-create.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-create/shared-abstract-create.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminUserCreateRoutable extends SharedAbstractCreateRoutable<UserExtended, AdminUserStateModel> {
  @Select((state: LocalStateModel) => state.shared.shared_person.list) listPersonObs: Observable<Person[]>;
  @Select((state: LocalStateModel) => state.shared.shared_organizationalUnit.list) listOrgUnitObs: Observable<AccessOrganizationalUnit[]>;

  @ViewChild("formPresentational", {static: false})
  readonly formPresentational: SharedAbstractFormPresentational<UserExtended>;

  constructor(protected store: Store) {
    super(store, LocalStateEnum.admin_user, adminUserActionNameSpace, LocalStateEnum.admin);
  }
}
