import {ChangeDetectionStrategy, Component, Inject,} from "@angular/core";
import {MAT_DIALOG_DATA, MatDialogRef,} from "@angular/material";
import {adminUserActionNameSpace} from "@admin/user/stores/admin-user.action";
import {AdminUserStateModel} from "@admin/user/stores/admin-user.state";
import {SharedAbstractDeleteDialog} from "@shared/components/dialogs/shared-abstract-delete/shared-abstract-delete.dialog";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {DeleteDialog} from "@shared/models/delete-dialog.model";
import {Store} from "@ngxs/store";
import {UserExtended} from "@shared/models/business/user-extended.model";
import {TRANSLATE} from "solidify-frontend";

@Component({
  selector: "dlcm-user-delete-dialog",
  templateUrl: "../../../../../shared/components/dialogs/shared-abstract-delete/shared-abstract-delete.dialog.html",
  styleUrls: ["../../../../../shared/components/dialogs/shared-abstract-delete/shared-abstract-delete.dialog.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminUserDeleteDialog extends SharedAbstractDeleteDialog<UserExtended, AdminUserStateModel> {
  public readonly KEY_TITLE: string = TRANSLATE("admin.user.dialog.delete.title");
  public readonly KEY_MESSAGE: string = TRANSLATE("admin.user.dialog.delete.message");
  public readonly KEY_CONFIRM_BUTTON: string = TRANSLATE("admin.user.dialog.delete.confirm");
  public readonly KEY_CANCEL_BUTTON: string = TRANSLATE("admin.user.dialog.delete.cancel");

  constructor(protected store: Store,
              protected dialogRef: MatDialogRef<AdminUserDeleteDialog>,
              @Inject(MAT_DIALOG_DATA) public data: DeleteDialog) {
    super(store, dialogRef, data, LocalStateEnum.admin_user, adminUserActionNameSpace);
  }

}
