import {NgModule} from "@angular/core";
import {SharedModule} from "@app/shared/shared.module";
import {TranslateModule} from "@ngx-translate/core";
import {NgxsModule} from "@ngxs/store";
import {AdminSubmissionPolicyState} from "@admin/submission-policy/stores/admin-submission-policy.state";
import {AdminSubmissionPolicyRoutingModule} from "@admin/submission-policy/submission-policy-routing.module";
import {AdminSubmissionPolicyListRoutable} from "@admin/submission-policy/components/routables/list/admin-submission-policy-list.routable";
import {AdminSubmissionPolicyDetailRoutable} from "@admin/submission-policy/components/routables/detail/admin-submission-policy-detail.routable";
import {AdminSubmissionPolicyEditRoutable} from "@admin/submission-policy/components/routables/edit/admin-submission-policy-edit.routable";
import {AdminSubmissionPolicyCreateRoutable} from "@admin/submission-policy/components/routables/create/admin-submission-policy-create.routable";
import {AdminSubmissionPolicyDeleteDialog} from "@admin/submission-policy/components/dialogs/admin-submission-policy-delete.dialog";
import {AdminSubmissionPolicyFormPresentational} from "@admin/submission-policy/components/presentationals/admin-submission-policy-form.presentational";

const routables = [
  AdminSubmissionPolicyListRoutable,
  AdminSubmissionPolicyDetailRoutable,
  AdminSubmissionPolicyEditRoutable,
  AdminSubmissionPolicyCreateRoutable
];
const containers = [];
const dialogs = [
  AdminSubmissionPolicyDeleteDialog
];
const presentationals = [
  AdminSubmissionPolicyFormPresentational
];

@NgModule({
  declarations: [
    ...routables,
    ...containers,
    ...dialogs,
    ...presentationals,
  ],
  imports: [
    SharedModule,
    AdminSubmissionPolicyRoutingModule,
    TranslateModule.forChild({}),
    NgxsModule.forFeature([
      AdminSubmissionPolicyState
    ]),
  ],
  entryComponents: [
    ...dialogs,
  ],
  exports: [
    ...routables,
  ],
  providers: [],
})
export class AdminSubmissionPolicyModule { }
