import {NgModule} from "@angular/core";
import {RouterModule, Routes} from "@angular/router";
import {AdminRoutesEnum, AppRoutesEnum} from "@shared/enums/routes.enum";
import {AdminSubmissionPolicyListRoutable} from "@admin/submission-policy/components/routables/list/admin-submission-policy-list.routable";
import {AdminSubmissionPolicyDetailRoutable} from "@admin/submission-policy/components/routables/detail/admin-submission-policy-detail.routable";
import {AdminSubmissionPolicyEditRoutable} from "@admin/submission-policy/components/routables/edit/admin-submission-policy-edit.routable";
import {AdminSubmissionPolicyCreateRoutable} from "@admin/submission-policy/components/routables/create/admin-submission-policy-create.routable";
import {TRANSLATE} from "solidify-frontend";

const routes: Routes = [
  {
    path: AppRoutesEnum.root,
    component: AdminSubmissionPolicyListRoutable,
    data: {
      breadcrumb: TRANSLATE("breadcrumb.admin.submissionPolicy.list"),
    },
  },
  {
    path: AdminRoutesEnum.submissionPolicy + AppRoutesEnum.separator + AdminRoutesEnum.submissionPolicyDetail + AppRoutesEnum.separator + AppRoutesEnum.paramId,
    component: AdminSubmissionPolicyDetailRoutable,
    data: {
      breadcrumb: TRANSLATE("breadcrumb.admin.submissionPolicy.detail"),
    },
  },
  {
    path: AdminRoutesEnum.submissionPolicy + AppRoutesEnum.separator + AdminRoutesEnum.submissionPolicyEdit + AppRoutesEnum.separator + AppRoutesEnum.paramId,
    component: AdminSubmissionPolicyEditRoutable,
    data: {
      breadcrumb: TRANSLATE("breadcrumb.admin.submissionPolicy.edit"),
    },
  },
  {
    path: AdminRoutesEnum.submissionPolicy + AppRoutesEnum.separator + AdminRoutesEnum.submissionPolicyCreate,
    component: AdminSubmissionPolicyCreateRoutable,
    data: {
      breadcrumb: TRANSLATE("breadcrumb.admin.submissionPolicy.create"),
    },
  },

];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class AdminSubmissionPolicyRoutingModule { }
