import {SubmissionPolicy} from "@app/generated-api";
import {AdminResourceApiEnum} from "@shared/enums/api.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {RoutesEnum} from "@shared/enums/routes.enum";
import {Actions, State, Store,} from "@ngxs/store";
import {
  ApiService,
  defaultResourceStateInitValue,
  NotificationService,
  ResourceState,
  ResourceStateModel,
  TRANSLATE,
} from "solidify-frontend";
import {adminSubmissionPolicyActionNameSpace} from "./admin-submission-policy.action";

export interface AdminSubmissionPolicyStateModel extends ResourceStateModel<SubmissionPolicy> {
}

@State<AdminSubmissionPolicyStateModel>({
  name: LocalStateEnum.admin_submissionPolicy,
  defaults: {
    ...defaultResourceStateInitValue,
  },
})
export class AdminSubmissionPolicyState extends ResourceState<SubmissionPolicy> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: adminSubmissionPolicyActionNameSpace,
      urlResource: AdminResourceApiEnum.submissionPolicies,
      routeRedirectUrlAfterSuccessAction: RoutesEnum.adminSubmissionPolicy,
      notificationResourceCreateTextToTranslate: TRANSLATE("admin.submissionPolicy.notification.resource.create"),
      notificationResourceDeleteTextToTranslate: TRANSLATE("admin.submissionPolicy.notification.resource.delete"),
      notificationResourceUpdateTextToTranslate: TRANSLATE("admin.submissionPolicy.notification.resource.update"),
    });
  }
}
