import {ChangeDetectionStrategy, Component,} from "@angular/core";
import {adminSubmissionPolicyActionNameSpace} from "@admin/submission-policy/stores/admin-submission-policy.action";
import {AdminSubmissionPolicyStateModel} from "@admin/submission-policy/stores/admin-submission-policy.state";
import {SubmissionPolicy} from "@app/generated-api";
import {SharedAbstractListRoutable} from "@shared/components/routables/shared-abstract-list/shared-abstract-list.routable";
import {FieldTypeEnum} from "@shared/enums/field-type.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {Store} from "@ngxs/store";
import {TRANSLATE} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-submission-policy-list-routable",
  templateUrl: "../../../../../../shared/components/routables/shared-abstract-list/shared-abstract-list.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-list/shared-abstract-list.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminSubmissionPolicyListRoutable extends SharedAbstractListRoutable<SubmissionPolicy, AdminSubmissionPolicyStateModel> {
  readonly KEY_CREATE_BUTTON: string = TRANSLATE("admin.submissionPolicy.button.new");
  readonly KEY_REFRESH_BUTTON: string = TRANSLATE("admin.submissionPolicy.button.refresh");

  constructor(protected store: Store) {
    super(store, LocalStateEnum.admin_submissionPolicy, adminSubmissionPolicyActionNameSpace, {}, LocalStateEnum.admin);
  }

  defineColumns(): void {
    this.columns = [
      {
        field: "name",
        header: TRANSLATE("admin.submissionPolicy.table.header.name"),
        type: FieldTypeEnum.string,
        order: 0,
        isFilterable: true,
        isSortable: true,
      },
      {
        field: "submissionApproval",
        header: TRANSLATE("admin.submissionPolicy.table.header.submissionApproval"),
        type: FieldTypeEnum.string,
        order: 0,
        isFilterable: true,
        isSortable: true,
      },
      {
        field: "creation.when" as any,
        header: TRANSLATE("admin.submissionPolicy.table.header.creation.when"),
        type: FieldTypeEnum.datetime,
        order: 0,
        isFilterable: true,
        isSortable: true,
      },
      {
        field: "lastUpdate.when" as any,
        header: TRANSLATE("admin.submissionPolicy.table.header.lastUpdate.when"),
        type: FieldTypeEnum.datetime,
        order: 0,
        isFilterable: true,
        isSortable: true,
      },
      {
        field: "timeToKeep",
        header: TRANSLATE("admin.submissionPolicy.table.header.timeToKeep"),
        type: FieldTypeEnum.number,
        order: 0,
        isFilterable: true,
        isSortable: true,
      },
    ];
  }
}
