import {ChangeDetectionStrategy, Component,} from "@angular/core";
import {ActivatedRoute} from "@angular/router";
import {adminSubmissionPolicyActionNameSpace} from "@admin/submission-policy/stores/admin-submission-policy.action";
import {AdminSubmissionPolicyStateModel} from "@admin/submission-policy/stores/admin-submission-policy.state";
import {SubmissionPolicy} from "@app/generated-api";
import {SharedAbstractEditRoutable} from "@shared/components/routables/shared-abstract-edit/shared-abstract-edit.routable";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {Store} from "@ngxs/store";

@Component({
  selector: "dlcm-admin-submission-policy-edit-routable",
  templateUrl: "./admin-submission-policy-edit.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-edit/shared-abstract-edit.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminSubmissionPolicyEditRoutable extends SharedAbstractEditRoutable<SubmissionPolicy, AdminSubmissionPolicyStateModel> {
  constructor(protected store: Store,
              protected route: ActivatedRoute) {
    super(store, route, LocalStateEnum.admin_submissionPolicy, adminSubmissionPolicyActionNameSpace, LocalStateEnum.admin);
  }

  getSubResourceWithParentId(id: string): void {
  }
}
