import {ChangeDetectionStrategy, Component, ViewChild,} from "@angular/core";
import {adminSubmissionPolicyActionNameSpace} from "@admin/submission-policy/stores/admin-submission-policy.action";
import {AdminSubmissionPolicyStateModel} from "@admin/submission-policy/stores/admin-submission-policy.state";
import {SubmissionPolicy} from "@app/generated-api";
import {SharedAbstractFormPresentational} from "@shared/components/presentationals/shared-abstract-form/shared-abstract-form.presentational";
import {SharedAbstractCreateRoutable} from "@shared/components/routables/shared-abstract-create/shared-abstract-create.routable";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {Store} from "@ngxs/store";

@Component({
  selector: "dlcm-admin-submission-policy-create-routable",
  templateUrl: "./admin-submission-policy-create.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-create/shared-abstract-create.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminSubmissionPolicyCreateRoutable extends SharedAbstractCreateRoutable<SubmissionPolicy, AdminSubmissionPolicyStateModel> {
  @ViewChild("formPresentational", {static: false})
  readonly formPresentational: SharedAbstractFormPresentational<SubmissionPolicy>;

  constructor(protected store: Store) {
    super(store, LocalStateEnum.admin_submissionPolicy, adminSubmissionPolicyActionNameSpace, LocalStateEnum.admin);
  }
}
