import {
  AdminFundingAgenciesState,
  AdminFundingAgenciesStateModel,
} from "@admin/funding-agencies/stores/admin-funding-agencies.state";
import {AdminInstitutionState, AdminInstitutionStateModel,} from "@admin/institution/stores/admin-institution.state";
import {AdminLicenseState, AdminLicenseStateModel,} from "@admin/license/stores/admin-license.state";
import {
  AdminOAuth2ClientState,
  AdminOAuth2ClientStateModel,
} from "@admin/oauth2-client/stores/admin-oauth2-client.state";
import {
  AdminOrganizationalUnitState,
  AdminOrganizationalUnitStateModel,
} from "@admin/orgunit/stores/admin-organizational-unit.state";
import {AdminPersonState, AdminPersonStateModel,} from "@admin/person/stores/admin-person.state";
import {
  AdminPreservationPolicyState,
  AdminPreservationPolicyStateModel,
} from "@admin/preservation-policy/stores/admin-preservation-policy.state";
import {AdminRoleState, AdminRoleStateModel,} from "@admin/role/stores/admin-role.state";
import {
  AdminSubmissionPolicyState,
  AdminSubmissionPolicyStateModel,
} from "@admin/submission-policy/stores/admin-submission-policy.state";
import {AdminUserState, AdminUserStateModel,} from "@admin/user/stores/admin-user.state";
import {LocalStateEnum} from "@app/shared/enums/local-state.enum";
import {State, Store,} from "@ngxs/store";
import {BaseStateModel} from "solidify-frontend";

export interface AdminStateModel extends BaseStateModel {
  admin_submissionPolicy: AdminSubmissionPolicyStateModel;
  admin_preservationPolicy: AdminPreservationPolicyStateModel;
  admin_license: AdminLicenseStateModel;
  admin_organizationalUnit: AdminOrganizationalUnitStateModel;
  admin_institution: AdminInstitutionStateModel;
  admin_user: AdminUserStateModel;
  admin_oauth2Client: AdminOAuth2ClientStateModel;
  admin_person: AdminPersonStateModel;
  admin_role: AdminRoleStateModel;
  admin_fundingAgencies: AdminFundingAgenciesStateModel;
}

@State<AdminStateModel>({
  name: LocalStateEnum.admin,
  defaults: {
    isLoadingCounter: 0,
    admin_submissionPolicy: null,
    admin_preservationPolicy: null,
    admin_license: null,
    admin_organizationalUnit: null,
    admin_institution: null,
    admin_user: null,
    admin_oauth2Client: null,
    admin_person: null,
    admin_role: null,
    admin_fundingAgencies: null,
  },
  children: [
    AdminSubmissionPolicyState,
    AdminPreservationPolicyState,
    AdminLicenseState,
    AdminOrganizationalUnitState,
    AdminInstitutionState,
    AdminUserState,
    AdminOAuth2ClientState,
    AdminPersonState,
    AdminRoleState,
    AdminFundingAgenciesState,
  ],
})
export class AdminState {
  constructor(protected store: Store) {
  }
}
