import {adminRoleActionNameSpace} from "@admin/role/stores/admin-role.action";
import {Role} from "@app/generated-api";
import {AdminResourceApiEnum} from "@shared/enums/api.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {RoutesEnum} from "@shared/enums/routes.enum";
import {Actions, State, Store,} from "@ngxs/store";
import {
  ApiService,
  defaultResourceStateInitValue,
  NotificationService,
  ResourceState,
  ResourceStateModel,
  TRANSLATE,
} from "solidify-frontend";

export interface AdminRoleStateModel extends ResourceStateModel<Role> {
}

@State<AdminRoleStateModel>({
  name: LocalStateEnum.admin_role,
  defaults: {
    ...defaultResourceStateInitValue,
  },

})
export class AdminRoleState extends ResourceState<Role> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: adminRoleActionNameSpace,
      urlResource: AdminResourceApiEnum.roles,
      routeRedirectUrlAfterSuccessAction: RoutesEnum.admin,
      notificationResourceCreateTextToTranslate: TRANSLATE("admin.roles.notification.resource.create"),
      notificationResourceDeleteTextToTranslate: TRANSLATE("admin.roles.notification.resource.delete"),
      notificationResourceUpdateTextToTranslate: TRANSLATE("admin.roles.notification.resource.update"),
    });
  }

}
