import {NgModule} from "@angular/core";
import {SharedModule} from "@app/shared/shared.module";
import {TranslateModule} from "@ngx-translate/core";
import {NgxsModule} from "@ngxs/store";
import {AdminRoleState} from "@admin/role/stores/admin-role.state";
import {AdminRoleRoutingModule} from "@admin/role/role-routing.module";
import {AdminRoleListRoutable} from "@admin/role/components/routables/list/admin-role-list.routable";
import {AdminRoleCreateRoutable} from "@admin/role/components/routables/create/admin-role-create.routable";
import {AdminRoleDetailRoutable} from "@admin/role/components/routables/detail/admin-role-detail.routable";
import {AdminRoleEditRoutable} from "@admin/role/components/routables/edit/admin-role-edit.routable";
import {AdminRoleDeleteDialog} from "@admin/role/components/dialogs/admin-role-delete.dialog";
import {AdminRoleFormPresentational} from "@admin/role/components/presentationals/admin-role-form.presentational";

const routables = [
  AdminRoleListRoutable,
  AdminRoleCreateRoutable,
  AdminRoleDetailRoutable,
  AdminRoleEditRoutable
];
const containers = [];
const dialogs = [
  AdminRoleDeleteDialog
];
const presentationals = [
  AdminRoleFormPresentational
];

@NgModule({
  declarations: [
    ...routables,
    ...containers,
    ...dialogs,
    ...presentationals,
  ],
  imports: [
    SharedModule,
    AdminRoleRoutingModule,
    TranslateModule.forChild({}),
    NgxsModule.forFeature([
      AdminRoleState
    ]),
  ],
  entryComponents: [
    ...dialogs,
  ],
  exports: [
    ...routables,
  ],
  providers: [],
})
export class AdminRoleModule { }
