import {NgModule} from "@angular/core";
import {RouterModule, Routes} from "@angular/router";
import {AdminRoutesEnum, AppRoutesEnum} from "@shared/enums/routes.enum";
import {AdminRoleListRoutable} from "@admin/role/components/routables/list/admin-role-list.routable";
import {AdminRoleCreateRoutable} from "@admin/role/components/routables/create/admin-role-create.routable";
import {AdminRoleDetailRoutable} from "@admin/role/components/routables/detail/admin-role-detail.routable";
import {AdminRoleEditRoutable} from "@admin/role/components/routables/edit/admin-role-edit.routable";
import {TRANSLATE} from "solidify-frontend";

const routes: Routes = [
  {
    path: AppRoutesEnum.root,
    component: AdminRoleListRoutable,
    data: {
      breadcrumb: TRANSLATE("breadcrumb.admin.role.list"),
    },
  },
  {
    component: AdminRoleCreateRoutable,
    path: AdminRoutesEnum.roleCreate,
    data: {
      breadcrumb: TRANSLATE("breadcrumb.admin.role.create"),
    },
  },
  {
    path: AdminRoutesEnum.roleDetail + AppRoutesEnum.separator + AppRoutesEnum.paramId,
    component: AdminRoleDetailRoutable,
    data: {
      breadcrumb: TRANSLATE("breadcrumb.admin.role.detail"),
    },
  },
  {
    path: AdminRoutesEnum.roleEdit + AppRoutesEnum.separator + AppRoutesEnum.paramId,
    component: AdminRoleEditRoutable,
    data: {
      breadcrumb: TRANSLATE("breadcrumb.admin.role.edit"),
    },
  }
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class AdminRoleRoutingModule { }
