import {ChangeDetectionStrategy, Component,} from "@angular/core";
import {adminRoleActionNameSpace} from "@admin/role/stores/admin-role.action";
import {AdminRoleStateModel} from "@admin/role/stores/admin-role.state";
import {Role} from "@app/generated-api";
import {SharedAbstractListRoutable} from "@shared/components/routables/shared-abstract-list/shared-abstract-list.routable";
import {FieldTypeEnum} from "@shared/enums/field-type.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {Store} from "@ngxs/store";
import {TRANSLATE} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-submission-policy-list-routable",
  templateUrl: "../../../../../../shared/components/routables/shared-abstract-list/shared-abstract-list.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-list/shared-abstract-list.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminRoleListRoutable extends SharedAbstractListRoutable<Role, AdminRoleStateModel> {
  readonly KEY_CREATE_BUTTON: string = TRANSLATE("admin.roles.button.new");
  readonly KEY_REFRESH_BUTTON: string = TRANSLATE("admin.roles.button.refresh");

  constructor(protected store: Store) {
    super(store, LocalStateEnum.admin_role, adminRoleActionNameSpace, {}, LocalStateEnum.admin);
  }

  defineColumns(): void {
    this.columns = [
      {
        field: "name",
        header: TRANSLATE("admin.roles.table.header.name"),
        type: FieldTypeEnum.string,
        order: 0,
        isFilterable: true,
        isSortable: true,
      },
    ];
  }
}
