import {ChangeDetectionStrategy, Component,} from "@angular/core";
import {ActivatedRoute} from "@angular/router";
import {adminRoleActionNameSpace} from "@admin/role/stores/admin-role.action";
import {AdminRoleStateModel} from "@admin/role/stores/admin-role.state";
import {Role} from "@app/generated-api";
import {SharedAbstractEditRoutable} from "@shared/components/routables/shared-abstract-edit/shared-abstract-edit.routable";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {Store} from "@ngxs/store";

@Component({
  selector: "dlcm-admin-submission-policy-edit-routable",
  templateUrl: "./admin-role-edit.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-edit/shared-abstract-edit.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminRoleEditRoutable extends SharedAbstractEditRoutable<Role, AdminRoleStateModel> {
  constructor(protected store: Store,
              protected route: ActivatedRoute) {
    super(store, route, LocalStateEnum.admin_role, adminRoleActionNameSpace, LocalStateEnum.admin);
  }

  getSubResourceWithParentId(id: string): void {
  }
}
