import {ChangeDetectionStrategy, Component,} from "@angular/core";
import {MatDialog} from "@angular/material";
import {ActivatedRoute} from "@angular/router";
import {adminRoleActionNameSpace} from "@admin/role/stores/admin-role.action";
import {AdminRoleStateModel} from "@admin/role/stores/admin-role.state";
import {Role} from "@app/generated-api";
import {SharedAbstractDetailRoutable} from "@shared/components/routables/shared-abstract-detail/shared-abstract-detail.routable";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {Store} from "@ngxs/store";
import {TRANSLATE} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-role-detail-routable",
  templateUrl: "./admin-role-detail.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-detail/shared-abstract-detail.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminRoleDetailRoutable extends SharedAbstractDetailRoutable<Role, AdminRoleStateModel> {
  readonly KEY_DELETE_BUTTON: string = TRANSLATE("admin.roles.button.delete");
  readonly KEY_EDIT_BUTTON: string = TRANSLATE("admin.roles.button.edit");
  readonly KEY_PARAM_NAME: string = "externalUid";

  constructor(protected store: Store,
              protected route: ActivatedRoute,
              public dialog: MatDialog) {
    super(store, route, dialog, LocalStateEnum.admin_role, adminRoleActionNameSpace, LocalStateEnum.admin);
  }

  getSubResourceWithParentId(id: string): void {
  }
}
