import {ChangeDetectionStrategy, Component, ViewChild,} from "@angular/core";
import {adminRoleActionNameSpace} from "@admin/role/stores/admin-role.action";
import {AdminRoleStateModel} from "@admin/role/stores/admin-role.state";
import {Role} from "@app/generated-api";
import {SharedAbstractFormPresentational} from "@shared/components/presentationals/shared-abstract-form/shared-abstract-form.presentational";
import {SharedAbstractCreateRoutable} from "@shared/components/routables/shared-abstract-create/shared-abstract-create.routable";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {Store} from "@ngxs/store";

@Component({
  selector: "dlcm-admin-role-create-routable",
  templateUrl: "./admin-role-create.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-create/shared-abstract-create.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminRoleCreateRoutable extends SharedAbstractCreateRoutable<Role, AdminRoleStateModel> {
  @ViewChild("formPresentational", {static: false})
  readonly formPresentational: SharedAbstractFormPresentational<Role>;

  constructor(protected store: Store) {
    super(store, LocalStateEnum.admin_role, adminRoleActionNameSpace, LocalStateEnum.admin);
  }
}
