import {ChangeDetectionStrategy, ChangeDetectorRef, Component,} from "@angular/core";
import {FormBuilder, Validators,} from "@angular/forms";
import {Role} from "@app/generated-api";
import {SharedAbstractFormPresentational} from "@shared/components/presentationals/shared-abstract-form/shared-abstract-form.presentational";
import {BaseFormDefinition} from "@shared/models/base-form-definition.model";
import {PropertyName, SolidifyValidator,} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-role-form",
  templateUrl: "./admin-role-form.presentational.html",
  styleUrls: ["../../../../../shared/components/presentationals/shared-abstract-form/shared-abstract-form.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminRoleFormPresentational extends SharedAbstractFormPresentational<Role> {
  formDefinition: FormComponentFormDefinition = new FormComponentFormDefinition();

  constructor(protected readonly _changeDetectorRef: ChangeDetectorRef,
              private readonly _fb: FormBuilder) {
    super(_changeDetectorRef);
  }

  protected bindFormTo(role: Role): void {
    this.form = this._fb.group({
      [this.formDefinition.name]: [role.name, [Validators.required, SolidifyValidator]],
    });
  }

  protected initNewForm(): void {
    this.form = this._fb.group({
      [this.formDefinition.name]: ["", [Validators.required, SolidifyValidator]],
    });
  }

  protected treatmentBeforeSubmit(role: Role): Role {
    return role;
  }
}

class FormComponentFormDefinition extends BaseFormDefinition {
  @PropertyName() name: string;
}
