import {ChangeDetectionStrategy, Component, Inject,} from "@angular/core";
import {MAT_DIALOG_DATA, MatDialogRef,} from "@angular/material";
import {adminRoleActionNameSpace} from "@admin/role/stores/admin-role.action";
import {AdminRoleStateModel} from "@admin/role/stores/admin-role.state";
import {Role} from "@app/generated-api";
import {SharedAbstractDeleteDialog} from "@shared/components/dialogs/shared-abstract-delete/shared-abstract-delete.dialog";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {DeleteDialog} from "@shared/models/delete-dialog.model";
import {Store} from "@ngxs/store";
import {TRANSLATE} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-role-delete-dialog",
  templateUrl: "../../../../../shared/components/dialogs/shared-abstract-delete/shared-abstract-delete.dialog.html",
  styleUrls: ["../../../../../shared/components/dialogs/shared-abstract-delete/shared-abstract-delete.dialog.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminRoleDeleteDialog extends SharedAbstractDeleteDialog<Role, AdminRoleStateModel> {
  public readonly KEY_TITLE: string = TRANSLATE("admin.roles.dialog.delete.title");
  public readonly KEY_MESSAGE: string = TRANSLATE("admin.roles.dialog.delete.message");
  public readonly KEY_CONFIRM_BUTTON: string = TRANSLATE("admin.roles.dialog.delete.confirm");
  public readonly KEY_CANCEL_BUTTON: string = TRANSLATE("admin.roles.dialog.delete.cancel");

  constructor(protected store: Store,
              protected dialogRef: MatDialogRef<AdminRoleDeleteDialog>,
              @Inject(MAT_DIALOG_DATA) public data: DeleteDialog) {
    super(store, dialogRef, data, LocalStateEnum.admin_role, adminRoleActionNameSpace);
  }
}
