import {PreservationPolicy} from "@app/generated-api";
import {AdminResourceApiEnum} from "@shared/enums/api.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {RoutesEnum} from "@shared/enums/routes.enum";
import {Actions, State, Store,} from "@ngxs/store";
import {
  ApiService,
  defaultResourceStateInitValue,
  NotificationService,
  ResourceState,
  ResourceStateModel,
  TRANSLATE,
} from "solidify-frontend";
import {adminPreservationPolicyActionNameSpace} from "./admin-preservation-policy.action";

export interface AdminPreservationPolicyStateModel extends ResourceStateModel<PreservationPolicy> {
}

@State<AdminPreservationPolicyStateModel>({
  name: LocalStateEnum.admin_preservationPolicy,
  defaults: {
    ...defaultResourceStateInitValue,
  },
})
export class AdminPreservationPolicyState extends ResourceState<PreservationPolicy> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: adminPreservationPolicyActionNameSpace,
      urlResource: AdminResourceApiEnum.preservationPolicies,
      routeRedirectUrlAfterSuccessAction: RoutesEnum.adminPreservationPolicy,
      notificationResourceCreateTextToTranslate: TRANSLATE("admin.preservationPolicy.notification.resource.create"),
      notificationResourceDeleteTextToTranslate: TRANSLATE("admin.preservationPolicy.notification.resource.delete"),
      notificationResourceUpdateTextToTranslate: TRANSLATE("admin.preservationPolicy.notification.resource.update"),
    });
  }
}
