import {NgModule} from "@angular/core";
import {SharedModule} from "@app/shared/shared.module";
import {TranslateModule} from "@ngx-translate/core";
import {NgxsModule} from "@ngxs/store";
import {AdminPreservationPolicyListRoutable} from "@admin/preservation-policy/components/routables/list/admin-preservation-policy-list.routable";
import {AdminPreservationPolicyDetailRoutable} from "@admin/preservation-policy/components/routables/detail/admin-preservation-policy-detail.routable";
import {AdminPreservationPolicyCreateRoutable} from "@admin/preservation-policy/components/routables/create/admin-preservation-policy-create.routable";
import {AdminPreservationPolicyEditRoutable} from "@admin/preservation-policy/components/routables/edit/admin-preservation-policy-edit.routable";
import {AdminPreservationPolicyDeleteDialog} from "@admin/preservation-policy/components/dialogs/admin-preservation-policy-delete.dialog";
import {AdminPreservationPolicyFormPresentational} from "@admin/preservation-policy/components/presentationals/admin-preservation-policy-form.presentational";
import {AdminPreservationPolicyRoutingModule} from "@admin/preservation-policy/preservation-policy-routing.module";
import {AdminPreservationPolicyState} from "@admin/preservation-policy/stores/admin-preservation-policy.state";

const routables = [
  AdminPreservationPolicyListRoutable,
  AdminPreservationPolicyDetailRoutable,
  AdminPreservationPolicyCreateRoutable,
  AdminPreservationPolicyEditRoutable,
];
const containers = [];
const dialogs = [
  AdminPreservationPolicyDeleteDialog,
];
const presentationals = [
  AdminPreservationPolicyFormPresentational,
];

@NgModule({
  declarations: [
    ...routables,
    ...containers,
    ...dialogs,
    ...presentationals,
  ],
  imports: [
    SharedModule,
    AdminPreservationPolicyRoutingModule,
    TranslateModule.forChild({}),
    NgxsModule.forFeature([
      AdminPreservationPolicyState
    ]),
  ],
  entryComponents: [
    ...dialogs,
  ],
  exports: [
    ...routables,
  ],
  providers: [],
})
export class AdminPreservationPolicyModule { }
