import {NgModule} from "@angular/core";
import {RouterModule, Routes} from "@angular/router";
import {AdminRoutesEnum, AppRoutesEnum} from "@shared/enums/routes.enum";
import {AdminPreservationPolicyListRoutable} from "@admin/preservation-policy/components/routables/list/admin-preservation-policy-list.routable";
import {AdminPreservationPolicyDetailRoutable} from "@admin/preservation-policy/components/routables/detail/admin-preservation-policy-detail.routable";
import {AdminPreservationPolicyCreateRoutable} from "@admin/preservation-policy/components/routables/create/admin-preservation-policy-create.routable";
import {AdminPreservationPolicyEditRoutable} from "@admin/preservation-policy/components/routables/edit/admin-preservation-policy-edit.routable";
import {TRANSLATE} from "solidify-frontend";

const routes: Routes = [
  {
    path: AppRoutesEnum.root,
    component: AdminPreservationPolicyListRoutable,
    data: {
      breadcrumb: TRANSLATE("breadcrumb.admin.preservationPolicy.list"),
    },
  },
  {
    path: AdminRoutesEnum.preservationPolicy + AppRoutesEnum.separator + AdminRoutesEnum.preservationPolicyDetail + AppRoutesEnum.separator + AppRoutesEnum.paramId,
    component: AdminPreservationPolicyDetailRoutable,
    data: {
      breadcrumb: TRANSLATE("breadcrumb.admin.preservationPolicy.detail"),
    },
  },
  {
    path: AdminRoutesEnum.preservationPolicy + AppRoutesEnum.separator + AdminRoutesEnum.preservationPolicyCreate,
    component: AdminPreservationPolicyCreateRoutable,
    data: {
      breadcrumb: TRANSLATE("breadcrumb.admin.preservationPolicy.create"),
    },
  },
  {
    path: AdminRoutesEnum.preservationPolicy + AppRoutesEnum.separator + AdminRoutesEnum.preservationPolicyEdit + AppRoutesEnum.separator + AppRoutesEnum.paramId,
    component: AdminPreservationPolicyEditRoutable,
    data: {
      breadcrumb: TRANSLATE("breadcrumb.admin.preservationPolicy.edit"),
    },
  },

];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class AdminPreservationPolicyRoutingModule { }
