import {ChangeDetectionStrategy, Component,} from "@angular/core";
import {adminPreservationPolicyActionNameSpace} from "@admin/preservation-policy/stores/admin-preservation-policy.action";
import {AdminPreservationPolicyStateModel} from "@admin/preservation-policy/stores/admin-preservation-policy.state";
import {PreservationPolicy} from "@app/generated-api";
import {SharedAbstractListRoutable} from "@shared/components/routables/shared-abstract-list/shared-abstract-list.routable";
import {FieldTypeEnum} from "@shared/enums/field-type.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {Store} from "@ngxs/store";
import {TRANSLATE} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-preservation-list-routable",
  templateUrl: "../../../../../../shared/components/routables/shared-abstract-list/shared-abstract-list.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-list/shared-abstract-list.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminPreservationPolicyListRoutable extends SharedAbstractListRoutable<PreservationPolicy, AdminPreservationPolicyStateModel> {
  readonly KEY_CREATE_BUTTON: string = TRANSLATE("admin.preservationPolicy.button.new");
  readonly KEY_REFRESH_BUTTON: string = TRANSLATE("admin.preservationPolicy.button.refresh");

  constructor(protected store: Store) {
    super(store, LocalStateEnum.admin_preservationPolicy, adminPreservationPolicyActionNameSpace, {}, LocalStateEnum.admin);
  }

  defineColumns(): void {
    this.columns = [
      {
        field: "name",
        header: TRANSLATE("admin.preservationPolicy.table.header.name"),
        type: FieldTypeEnum.string,
        order: 0,
        isFilterable: true,
        isSortable: true,
      },
      {
        field: "dispositionApproval",
        header: TRANSLATE("admin.preservationPolicy.table.header.dispositionApproval"),
        type: FieldTypeEnum.string,
        order: 0,
        isFilterable: true,
        isSortable: true,
      },
      {
        field: "creation.when" as any,
        header: TRANSLATE("admin.preservationPolicy.table.header.creation.when"),
        type: FieldTypeEnum.datetime,
        order: 0,
        isFilterable: true,
        isSortable: true,
      },
      {
        field: "lastUpdate.when" as any,
        header: TRANSLATE("admin.preservationPolicy.table.header.lastUpdate.when"),
        type: FieldTypeEnum.datetime,
        order: 0,
        isFilterable: true,
        isSortable: true,
      },
      {
        field: "retention",
        header: TRANSLATE("admin.preservationPolicy.table.header.retention"),
        type: FieldTypeEnum.number,
        order: 0,
        isFilterable: true,
        isSortable: false,
      },
    ];
  }

}
