import {ChangeDetectionStrategy, Component,} from "@angular/core";
import {ActivatedRoute} from "@angular/router";
import {adminPreservationPolicyActionNameSpace} from "@admin/preservation-policy/stores/admin-preservation-policy.action";
import {AdminPreservationPolicyStateModel} from "@admin/preservation-policy/stores/admin-preservation-policy.state";
import {PreservationPolicy} from "@app/generated-api";
import {SharedAbstractEditRoutable} from "@shared/components/routables/shared-abstract-edit/shared-abstract-edit.routable";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {Store} from "@ngxs/store";

@Component({
  selector: "dlcm-admin-preservation-policy-edit-routable",
  templateUrl: "./admin-preservation-policy-edit.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-edit/shared-abstract-edit.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminPreservationPolicyEditRoutable extends SharedAbstractEditRoutable<PreservationPolicy, AdminPreservationPolicyStateModel> {
  constructor(protected store: Store,
              protected route: ActivatedRoute) {
    super(store, route, LocalStateEnum.admin_preservationPolicy, adminPreservationPolicyActionNameSpace, LocalStateEnum.admin);
  }

  getSubResourceWithParentId(id: string): void {
  }
}
