import {ChangeDetectionStrategy, Component,} from "@angular/core";
import {MatDialog} from "@angular/material";
import {ActivatedRoute} from "@angular/router";
import {adminPreservationPolicyActionNameSpace} from "@admin/preservation-policy/stores/admin-preservation-policy.action";
import {AdminPreservationPolicyStateModel} from "@admin/preservation-policy/stores/admin-preservation-policy.state";
import {PreservationPolicy} from "@app/generated-api";
import {SharedAbstractDetailRoutable} from "@shared/components/routables/shared-abstract-detail/shared-abstract-detail.routable";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {Store} from "@ngxs/store";
import {TRANSLATE} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-preservation-policy-detail-routable",
  templateUrl: "./admin-preservation-policy-detail.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-detail/shared-abstract-detail.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminPreservationPolicyDetailRoutable extends SharedAbstractDetailRoutable<PreservationPolicy, AdminPreservationPolicyStateModel> {
  readonly KEY_PARAM_NAME: string = "name";
  readonly KEY_DELETE_BUTTON: string = TRANSLATE("admin.preservationPolicy.button.delete");
  readonly KEY_EDIT_BUTTON: string = TRANSLATE("admin.preservationPolicy.button.edit");

  constructor(protected store: Store,
              protected route: ActivatedRoute,
              public dialog: MatDialog) {
    super(store, route, dialog, LocalStateEnum.admin_preservationPolicy, adminPreservationPolicyActionNameSpace, LocalStateEnum.admin);
  }

  getSubResourceWithParentId(id: string): void {
  }

}
