import {ChangeDetectionStrategy, Component, ViewChild,} from "@angular/core";
import {adminPreservationPolicyActionNameSpace} from "@admin/preservation-policy/stores/admin-preservation-policy.action";
import {AdminPreservationPolicyStateModel} from "@admin/preservation-policy/stores/admin-preservation-policy.state";
import {PreservationPolicy} from "@app/generated-api";
import {SharedAbstractFormPresentational} from "@shared/components/presentationals/shared-abstract-form/shared-abstract-form.presentational";
import {SharedAbstractCreateRoutable} from "@shared/components/routables/shared-abstract-create/shared-abstract-create.routable";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {Store} from "@ngxs/store";

@Component({
  selector: "dlcm-admin-preservation-policy-create-routable",
  templateUrl: "./admin-preservation-policy-create.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-create/shared-abstract-create.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminPreservationPolicyCreateRoutable extends SharedAbstractCreateRoutable<PreservationPolicy, AdminPreservationPolicyStateModel> {
  @ViewChild("formPresentational", {static: false})
  readonly formPresentational: SharedAbstractFormPresentational<PreservationPolicy>;

  constructor(protected store: Store) {
    super(store, LocalStateEnum.admin_preservationPolicy, adminPreservationPolicyActionNameSpace, LocalStateEnum.admin);
  }
}
