import {ChangeDetectionStrategy, ChangeDetectorRef, Component,} from "@angular/core";
import {FormBuilder, Validators,} from "@angular/forms";
import {PreservationPolicy} from "@app/generated-api";
import {SharedAbstractFormPresentational} from "@shared/components/presentationals/shared-abstract-form/shared-abstract-form.presentational";
import {BaseFormDefinition} from "@shared/models/base-form-definition.model";
import {PropertyName, SolidifyValidator,} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-preservation-policy-form",
  templateUrl: "./admin-preservation-policy-form.presentational.html",
  styleUrls: ["../../../../../shared/components/presentationals/shared-abstract-form/shared-abstract-form.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminPreservationPolicyFormPresentational extends SharedAbstractFormPresentational<PreservationPolicy> {
  formDefinition: FormComponentFormDefinition = new FormComponentFormDefinition();

  constructor(protected readonly _changeDetectorRef: ChangeDetectorRef,
              private readonly _fb: FormBuilder) {
    super(_changeDetectorRef);
  }

  protected bindFormTo(preservationPolicies: PreservationPolicy): void {
    this.form = this._fb.group({
      [this.formDefinition.name]: [preservationPolicies.name, [Validators.required, SolidifyValidator]],
      [this.formDefinition.dispositionApproval]: [preservationPolicies.dispositionApproval, [SolidifyValidator]],
      [this.formDefinition.retention]: [preservationPolicies.retention, [SolidifyValidator]],
    });
  }

  protected initNewForm(): void {
    this.form = this._fb.group({
      [this.formDefinition.name]: ["", [Validators.required, SolidifyValidator]],
      [this.formDefinition.dispositionApproval]: [false, [SolidifyValidator]],
      [this.formDefinition.retention]: [0, [SolidifyValidator]],
    });
  }

  protected treatmentBeforeSubmit(preservationPolicies: PreservationPolicy): PreservationPolicy {
    return preservationPolicies;
  }

}

class FormComponentFormDefinition extends BaseFormDefinition {
  @PropertyName() name: string;
  @PropertyName() dispositionApproval: string;
  @PropertyName() retention: string;
}
