import {PersonExtended} from "@admin/models/person-extended.model";
import {adminPersonActionNameSpace} from "@admin/person/stores/admin-person.action";
import {AdminResourceApiEnum} from "@shared/enums/api.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {RoutesEnum} from "@shared/enums/routes.enum";
import {Actions, State, Store,} from "@ngxs/store";
import {
  ApiService,
  defaultResourceStateInitValue,
  NotificationService,
  ResourceState,
  ResourceStateModel,
  TRANSLATE,
} from "solidify-frontend";

export interface AdminPersonStateModel extends ResourceStateModel<PersonExtended> {
}

@State<AdminPersonStateModel>({
  name: LocalStateEnum.admin_person,
  defaults: {
    ...defaultResourceStateInitValue,
  },

})
export class AdminPersonState extends ResourceState<PersonExtended> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: adminPersonActionNameSpace,
      urlResource: AdminResourceApiEnum.people,
      routeRedirectUrlAfterSuccessAction: RoutesEnum.adminPerson,
      notificationResourceCreateTextToTranslate: TRANSLATE("admin.person.notification.resource.create"),
      notificationResourceDeleteTextToTranslate: TRANSLATE("admin.person.notification.resource.delete"),
      notificationResourceUpdateTextToTranslate: TRANSLATE("admin.person.notification.resource.update"),
    });
  }
}
