import {NgModule} from "@angular/core";
import {SharedModule} from "@app/shared/shared.module";
import {TranslateModule} from "@ngx-translate/core";
import {NgxsModule} from "@ngxs/store";
import {AdminOrgunitRoutingModule} from "@admin/orgunit/orgunit-routing.module";
import {AdminPersonListRoutable} from "@admin/person/components/routables/list/admin-person-list-routable";
import {AdminPersonDetailRoutable} from "@admin/person/components/routables/detail/admin-person-detail.routable";
import {AdminPersonCreateRoutable} from "@admin/person/components/routables/create/admin-person-create.routable";
import {AdminPersonEditRoutable} from "@admin/person/components/routables/edit/admin-person-edit.routable";
import {AdminPersonDeleteDialog} from "@admin/person/components/dialogs/admin-person-delete.dialog";
import {AdminPersonForm} from "@admin/person/components/presentationals/admin-person-form";
import {AdminPersonState} from "@admin/person/stores/admin-person.state";

const routables = [
  AdminPersonListRoutable,
  AdminPersonDetailRoutable,
  AdminPersonCreateRoutable,
  AdminPersonEditRoutable,
];
const containers = [];
const dialogs = [
  AdminPersonDeleteDialog,
];
const presentationals = [
  AdminPersonForm,
];

@NgModule({
  declarations: [
    ...routables,
    ...containers,
    ...dialogs,
    ...presentationals,
  ],
  imports: [
    SharedModule,
    AdminOrgunitRoutingModule,
    TranslateModule.forChild({}),
    NgxsModule.forFeature([
      AdminPersonState
    ]),
  ],
  entryComponents: [
    ...dialogs,
  ],
  exports: [
    ...routables,
  ],
  providers: [],
})
export class AdminPersonModule { }
