import {NgModule} from "@angular/core";
import {RouterModule, Routes} from "@angular/router";
import {AdminRoutesEnum, AppRoutesEnum} from "@shared/enums/routes.enum";
import {AdminPersonListRoutable} from "@admin/person/components/routables/list/admin-person-list-routable";
import {ApplicationRolePermissionEnum} from "@shared/enums/application-role-permission.enum";
import {ApplicationRoleGuardService} from "@shared/guards/application-role-guard.service";
import {AdminPersonDetailRoutable} from "@admin/person/components/routables/detail/admin-person-detail.routable";
import {AdminPersonCreateRoutable} from "@admin/person/components/routables/create/admin-person-create.routable";
import {AdminPersonEditRoutable} from "@admin/person/components/routables/edit/admin-person-edit.routable";
import {TRANSLATE} from "solidify-frontend";

const routes: Routes = [
  {
    path: AppRoutesEnum.root,
    component: AdminPersonListRoutable,
    data: {
      breadcrumb: TRANSLATE("breadcrumb.admin.person.list"),
      permission: ApplicationRolePermissionEnum.rootPermission,
    },
    canActivate: [ApplicationRoleGuardService],
  },
  {
    path: AdminRoutesEnum.personDetail + AppRoutesEnum.separator + AppRoutesEnum.paramId,
    component: AdminPersonDetailRoutable,
    data: {
      breadcrumb: TRANSLATE("breadcrumb.admin.person.detail"),
      permission: ApplicationRolePermissionEnum.rootPermission,
    },
  },
  {
    path: AdminRoutesEnum.personCreate,
    component: AdminPersonCreateRoutable,
    data: {
      breadcrumb: TRANSLATE("breadcrumb.admin.person.create"),
    },
  },
  {
    path: AdminRoutesEnum.personEdit + AppRoutesEnum.separator + AppRoutesEnum.paramId,
    component: AdminPersonEditRoutable,
    data: {
      breadcrumb: TRANSLATE("breadcrumb.admin.person.edit"),
    },
  },

];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class AdminPersonRoutingModule { }
