import {ChangeDetectionStrategy, Component,} from "@angular/core";
import {PersonExtended} from "@admin/models/person-extended.model";
import {adminPersonActionNameSpace} from "@admin/person/stores/admin-person.action";
import {AdminPersonStateModel} from "@admin/person/stores/admin-person.state";
import {SharedAbstractListRoutable} from "@shared/components/routables/shared-abstract-list/shared-abstract-list.routable";
import {FieldTypeEnum} from "@shared/enums/field-type.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {Store} from "@ngxs/store";
import {TRANSLATE} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-person-list-routable",
  templateUrl: "../../../../../../shared/components/routables/shared-abstract-list/shared-abstract-list.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-list/shared-abstract-list.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminPersonListRoutable extends SharedAbstractListRoutable<PersonExtended, AdminPersonStateModel> {
  readonly KEY_CREATE_BUTTON: string = TRANSLATE("admin.person.button.new");
  readonly KEY_REFRESH_BUTTON: string = TRANSLATE("admin.person.button.refresh");

  constructor(protected store: Store) {
    super(store, LocalStateEnum.admin_person, adminPersonActionNameSpace, {}, LocalStateEnum.admin);
  }

  defineColumns(): void {
    this.columns = [
      {
        field: "lastName",
        header: TRANSLATE("admin.person.table.header.lastName"),
        type: FieldTypeEnum.string,
        order: 0,
        isFilterable: true,
        isSortable: true,
      },
      {
        field: "firstName",
        header: TRANSLATE("admin.person.table.header.firstName"),
        type: FieldTypeEnum.string,
        order: 0,
        isFilterable: true,
        isSortable: true,
      },
      {
        field: "orcid",
        header: TRANSLATE("admin.person.table.header.orcid"),
        type: FieldTypeEnum.string,
        order: 0,
        isFilterable: true,
        isSortable: true,
      },
    ];
  }
}
