import {ChangeDetectionStrategy, Component,} from "@angular/core";
import {ActivatedRoute} from "@angular/router";
import {PersonExtended} from "@admin/models/person-extended.model";
import {adminPersonActionNameSpace} from "@admin/person/stores/admin-person.action";
import {AdminPersonStateModel} from "@admin/person/stores/admin-person.state";
import {AccessOrganizationalUnit, Institution,} from "@app/generated-api";
import {SharedAbstractEditRoutable} from "@shared/components/routables/shared-abstract-edit/shared-abstract-edit.routable";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {LocalStateModel} from "@shared/models/local-state.model";
import {Select, Store,} from "@ngxs/store";
import {Observable} from "rxjs";

@Component({
  selector: "dlcm-admin-person-edit-routable",
  templateUrl: "./admin-person-edit.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-edit/shared-abstract-edit.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminPersonEditRoutable extends SharedAbstractEditRoutable<PersonExtended, AdminPersonStateModel> {
  @Select((state: LocalStateModel) => state.shared.shared_institution.list) listInstitutionsObs: Observable<Institution[]>;
  @Select((state: LocalStateModel) => state.shared.shared_organizationalUnit.list) listOrgUnitObs: Observable<AccessOrganizationalUnit[]>;

  constructor(protected store: Store,
              protected route: ActivatedRoute) {
    super(store, route, LocalStateEnum.admin_person, adminPersonActionNameSpace, LocalStateEnum.admin);
  }

  getSubResourceWithParentId(id: string): void {
  }
}
