import {ChangeDetectionStrategy, Component,} from "@angular/core";
import {MatDialog} from "@angular/material";
import {ActivatedRoute} from "@angular/router";
import {PersonExtended} from "@admin/models/person-extended.model";
import {adminPersonActionNameSpace} from "@admin/person/stores/admin-person.action";
import {AdminPersonStateModel} from "@admin/person/stores/admin-person.state";
import {AccessOrganizationalUnit, Institution,} from "@app/generated-api";
import {SharedAbstractDetailRoutable} from "@shared/components/routables/shared-abstract-detail/shared-abstract-detail.routable";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {LocalStateModel} from "@shared/models/local-state.model";
import {Select, Store,} from "@ngxs/store";
import {Observable} from "rxjs";
import {TRANSLATE} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-person-detail-routable",
  templateUrl: "./admin-person-detail.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-detail/shared-abstract-detail.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminPersonDetailRoutable extends SharedAbstractDetailRoutable<PersonExtended, AdminPersonStateModel> {
  @Select((state: LocalStateModel) => state.shared.shared_institution.list) listInstitutionsObs: Observable<Institution[]>;
  @Select((state: LocalStateModel) => state.shared.shared_organizationalUnit.list) listOrgUnitObs: Observable<AccessOrganizationalUnit[]>;

  readonly KEY_DELETE_BUTTON: string = TRANSLATE("admin.person.button.delete");
  readonly KEY_EDIT_BUTTON: string = TRANSLATE("admin.person.button.edit");
  readonly KEY_PARAM_NAME: string = "externalUid";

  constructor(protected store: Store,
              protected route: ActivatedRoute,
              public dialog: MatDialog) {
    super(store, route, dialog, LocalStateEnum.admin_person, adminPersonActionNameSpace, LocalStateEnum.admin);
  }

  getSubResourceWithParentId(id: string): void {
  }
}
