import {ChangeDetectionStrategy, Component, ViewChild,} from "@angular/core";
import {PersonExtended} from "@admin/models/person-extended.model";
import {adminPersonActionNameSpace} from "@admin/person/stores/admin-person.action";
import {AdminPersonStateModel} from "@admin/person/stores/admin-person.state";
import {AccessOrganizationalUnit, Institution,} from "@app/generated-api";
import {SharedAbstractFormPresentational} from "@shared/components/presentationals/shared-abstract-form/shared-abstract-form.presentational";
import {SharedAbstractCreateRoutable} from "@shared/components/routables/shared-abstract-create/shared-abstract-create.routable";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {LocalStateModel} from "@shared/models/local-state.model";
import {Select, Store,} from "@ngxs/store";
import {Observable} from "rxjs";

@Component({
  selector: "dlcm-admin-person-create-routable",
  templateUrl: "./admin-person-create.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-create/shared-abstract-create.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminPersonCreateRoutable extends SharedAbstractCreateRoutable<PersonExtended, AdminPersonStateModel> {
  @Select((state: LocalStateModel) => state.shared.shared_institution.list) listInstitutionsObs: Observable<Institution[]>;
  @Select((state: LocalStateModel) => state.shared.shared_organizationalUnit.list) listOrgUnitObs: Observable<AccessOrganizationalUnit[]>;

  @ViewChild("formPresentational", {static: false})
  readonly formPresentational: SharedAbstractFormPresentational<PersonExtended>;

  constructor(protected store: Store) {
    super(store, LocalStateEnum.admin_person, adminPersonActionNameSpace, LocalStateEnum.admin);
  }
}
