import {ChangeDetectionStrategy, ChangeDetectorRef, Component, Input,} from "@angular/core";
import {FormBuilder, Validators,} from "@angular/forms";
import {PersonExtended} from "@admin/models/person-extended.model";
import {AccessOrganizationalUnit, Institution,} from "@app/generated-api";
import {SharedAbstractFormPresentational} from "@shared/components/presentationals/shared-abstract-form/shared-abstract-form.presentational";
import {BaseFormDefinition} from "@shared/models/base-form-definition.model";
import {PropertyName, SolidifyValidator,} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-person-form",
  templateUrl: "./admin-person-form.html",
  styleUrls: ["../../../../../shared/components/presentationals/shared-abstract-form/shared-abstract-form.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminPersonForm extends SharedAbstractFormPresentational<PersonExtended> {
  formDefinition: FormComponentFormDefinition = new FormComponentFormDefinition();

  @Input()
  listInstitutions: Institution[];

  @Input()
  listOrganizationalUnit: AccessOrganizationalUnit[];

  constructor(protected readonly _changeDetectorRef: ChangeDetectorRef,
              private readonly _fb: FormBuilder) {
    super(_changeDetectorRef);
  }

  protected bindFormTo(person: PersonExtended): void {
    this.form = this._fb.group({
      [this.formDefinition.firstName]: [person.firstName, [Validators.required, SolidifyValidator]],
      [this.formDefinition.lastName]: [person.lastName, [Validators.required, SolidifyValidator]],
      [this.formDefinition.orcid]: [person.orcid],
    });
  }

  protected initNewForm(): void {
    this.form = this._fb.group({
      [this.formDefinition.firstName]: ["", [Validators.required, SolidifyValidator]],
      [this.formDefinition.lastName]: ["", [Validators.required, SolidifyValidator]],
      [this.formDefinition.orcid]: [""],
    });
  }

  protected treatmentBeforeSubmit(person: PersonExtended): PersonExtended {
    return person;
  }
}

class FormComponentFormDefinition extends BaseFormDefinition {
  @PropertyName() firstName: string;
  @PropertyName() lastName: string;
  @PropertyName() orcid: string;
}
