import {OrganizationalUnitSubmissionPolicy} from "@admin/models/organizational-unit-submission-policy.model";
import {adminOrgUnitSubmissionPolicyActionNameSpace} from "@admin/orgunit/stores/submission-policy/admin-organizational-unit-submission-policy.action";
import {SubmissionPolicy} from "@app/generated-api";
import {ApiResourceNameEnum} from "@shared/enums/api-resource-name.enum";
import {AdminResourceApiEnum} from "@shared/enums/api.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";

import {Actions, State, Store,} from "@ngxs/store";
import {
  ApiService,
  defaultRelation2TiersStateInitValue,
  NotificationService,
  Relation2TiersState,
  Relation2TiersStateModel,
} from "solidify-frontend";

export interface AdminOrganizationalUnitSubmissionPolicyStateModel extends Relation2TiersStateModel<SubmissionPolicy> {
}

@State<AdminOrganizationalUnitSubmissionPolicyStateModel>({
  name: LocalStateEnum.admin_organizationalUnit_submissionPolicy,
  defaults: {
    ...defaultRelation2TiersStateInitValue,
  },
})
export class AdminOrganizationalUnitSubmissionPolicyState extends Relation2TiersState<SubmissionPolicy, OrganizationalUnitSubmissionPolicy> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: adminOrgUnitSubmissionPolicyActionNameSpace,
      urlResource: AdminResourceApiEnum.organizationalUnits,
      resourceName: ApiResourceNameEnum.SUB_POLICY,
    });
  }
}
