import {OrganizationalUnitPreservationPolicy} from "@admin/models/organizational-unit-preservation-policy.model";
import {adminOrgUnitPreservationPolicyActionNameSpace} from "@admin/orgunit/stores/preservation-policy/admin-organizational-unit-preservation-policy.action";
import {PreservationPolicy} from "@app/generated-api";
import {ApiResourceNameEnum} from "@shared/enums/api-resource-name.enum";
import {AdminResourceApiEnum} from "@shared/enums/api.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";

import {Actions, State, Store,} from "@ngxs/store";
import {
  ApiService,
  defaultRelation2TiersStateInitValue,
  NotificationService,
  Relation2TiersState,
  Relation2TiersStateModel,
} from "solidify-frontend";

export interface AdminOrganizationalUnitPreservationPolicyStateModel extends Relation2TiersStateModel<PreservationPolicy> {
}

@State<AdminOrganizationalUnitPreservationPolicyStateModel>({
  name: LocalStateEnum.admin_organizationalUnit_preservationPolicy,
  defaults: {
    ...defaultRelation2TiersStateInitValue,
  },
})
export class AdminOrganizationalUnitPreservationPolicyState extends Relation2TiersState<PreservationPolicy, OrganizationalUnitPreservationPolicy> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: adminOrgUnitPreservationPolicyActionNameSpace,
      urlResource: AdminResourceApiEnum.organizationalUnits,
      resourceName: ApiResourceNameEnum.PRES_POLICY,
    });
  }
}
