import {NgModule} from "@angular/core";
import {SharedModule} from "@app/shared/shared.module";
import {TranslateModule} from "@ngx-translate/core";
import {NgxsModule} from "@ngxs/store";
import {AdminOrgunitRoutingModule} from "@admin/orgunit/orgunit-routing.module";
import {AdminOrganizationalUnitState} from "@admin/orgunit/stores/admin-organizational-unit.state";
import {AdminOrgunitDetailRoutable} from "@admin/orgunit/components/routables/detail/admin-orgunit-detail.routable";
import {AdminOrgunitListRoutable} from "@admin/orgunit/components/routables/list/admin-orgunit-list.routable";
import {AdminOrgunitCreateRoutable} from "@admin/orgunit/components/routables/create/admin-orgunit-create.routable";
import {AdminOrgunitEditRoutable} from "@admin/orgunit/components/routables/edit/admin-orgunit-edit.routable";
import {AdminOrgunitDeleteDialog} from "@admin/orgunit/components/dialogs/admin-orgunit-delete.dialog";
import {AdminOrgunitFormPresentational} from "@admin/orgunit/components/presentationals/admin-orgunit-form.presentational";

const routables = [
  AdminOrgunitDetailRoutable,
  AdminOrgunitListRoutable,
  AdminOrgunitCreateRoutable,
  AdminOrgunitEditRoutable
];
const containers = [];
const dialogs = [
  AdminOrgunitDeleteDialog
];
const presentationals = [
  AdminOrgunitFormPresentational
];

@NgModule({
  declarations: [
    ...routables,
    ...containers,
    ...dialogs,
    ...presentationals,
  ],
  imports: [
    SharedModule,
    AdminOrgunitRoutingModule,
    TranslateModule.forChild({}),
    NgxsModule.forFeature([
      AdminOrganizationalUnitState
    ]),
  ],
  entryComponents: [
    ...dialogs,
  ],
  exports: [
    ...routables,
  ],
  providers: [],
})
export class AdminOrgunitModule { }
