import {NgModule} from "@angular/core";
import {RouterModule, Routes} from "@angular/router";
import {AdminRoutesEnum, AppRoutesEnum} from "@shared/enums/routes.enum";
import {TRANSLATE} from "solidify-frontend";
import {AdminOrgunitListRoutable} from "@admin/orgunit/components/routables/list/admin-orgunit-list.routable";
import {AdminOrgunitDetailRoutable} from "@admin/orgunit/components/routables/detail/admin-orgunit-detail.routable";
import {AdminOrgunitEditRoutable} from "@admin/orgunit/components/routables/edit/admin-orgunit-edit.routable";
import {AdminOrgunitCreateRoutable} from "@admin/orgunit/components/routables/create/admin-orgunit-create.routable";

const routes: Routes = [
  {
    path: AppRoutesEnum.root,
    component: AdminOrgunitListRoutable,
    data: {
      breadcrumb: TRANSLATE("breadcrumb.admin.organizationalUnit.list"),
    },
  },
  {
    path: AdminRoutesEnum.organizationalUnitDetail + AppRoutesEnum.separator + AppRoutesEnum.paramId,
    component: AdminOrgunitDetailRoutable,
    data: {
      breadcrumb: TRANSLATE("breadcrumb.admin.organizationalUnit.detail"),
    },
  },
  {
    path: AdminRoutesEnum.organizationalUnitEdit + AppRoutesEnum.separator + AppRoutesEnum.paramId,
    component: AdminOrgunitEditRoutable,
    data: {
      breadcrumb: TRANSLATE("breadcrumb.admin.organizationalUnit.edit"),
    },
  },
  {
    path: AdminRoutesEnum.organizationalUnitCreate,
    component: AdminOrgunitCreateRoutable,
    data: {
      breadcrumb: TRANSLATE("breadcrumb.admin.organizationalUnit.create"),
    },
  },

];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class AdminOrgunitRoutingModule { }
