import {ChangeDetectionStrategy, Component,} from "@angular/core";
import {adminOrgUnitActionNameSpace} from "@admin/orgunit/stores/admin-organizational-unit.action";
import {AdminOrganizationalUnitStateModel} from "@admin/orgunit/stores/admin-organizational-unit.state";
import {OrganizationalUnitExtended} from "@deposit/models/organizational-unit-extended.model";
import {SharedAbstractListRoutable} from "@shared/components/routables/shared-abstract-list/shared-abstract-list.routable";
import {FieldTypeEnum} from "@shared/enums/field-type.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {Store} from "@ngxs/store";
import {TRANSLATE} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-orgunit-list-routable",
  templateUrl: "../../../../../../shared/components/routables/shared-abstract-list/shared-abstract-list.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-list/shared-abstract-list.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminOrgunitListRoutable extends SharedAbstractListRoutable<OrganizationalUnitExtended, AdminOrganizationalUnitStateModel> {
  readonly KEY_CREATE_BUTTON: string = TRANSLATE("admin.organizationalUnit.new");
  readonly KEY_REFRESH_BUTTON: string = TRANSLATE("admin.organizationalUnit.refresh");

  constructor(protected store: Store) {
    super(store, LocalStateEnum.admin_organizationalUnit, adminOrgUnitActionNameSpace, {}, LocalStateEnum.admin);
  }

  defineColumns(): void {
    this.columns = [
      {
        field: "name",
        header: TRANSLATE("admin.organizationalUnit.table.header.name"),
        type: FieldTypeEnum.string,
        order: -1,
        isFilterable: true,
        isSortable: true,
      },
      {
        field: "description",
        header: TRANSLATE("admin.organizationalUnit.table.header.description"),
        type: FieldTypeEnum.string,
        order: 0,
        isFilterable: true,
        isSortable: true,
      },
      {
        field: "creation.when" as any,
        header: TRANSLATE("admin.organizationalUnit.table.header.creation.when"),
        type: FieldTypeEnum.datetime,
        order: 0,
        isFilterable: true,
        isSortable: true,
      },
    ];
  }
}
