import {ChangeDetectionStrategy, Component,} from "@angular/core";
import {MatDialog} from "@angular/material";
import {ActivatedRoute} from "@angular/router";
import {adminOrgUnitActionNameSpace} from "@admin/orgunit/stores/admin-organizational-unit.action";
import {AdminOrganizationalUnitStateModel} from "@admin/orgunit/stores/admin-organizational-unit.state";
import {AdminOrgUnitPreservationPolicyAction} from "@admin/orgunit/stores/preservation-policy/admin-organizational-unit-preservation-policy.action";
import {AdminOrgUnitSubmissionPolicyAction} from "@admin/orgunit/stores/submission-policy/admin-organizational-unit-submission-policy.action";
import {OrganizationalUnitExtended} from "@deposit/models/organizational-unit-extended.model";
import {PreservationPolicy, SubmissionPolicy,} from "@app/generated-api";
import {SharedAbstractDetailRoutable} from "@shared/components/routables/shared-abstract-detail/shared-abstract-detail.routable";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {LocalStateModel} from "@shared/models/local-state.model";
import {Select, Store,} from "@ngxs/store";
import {Observable} from "rxjs";
import {StoreUtil, TRANSLATE,} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-orgunit-detail-routable",
  templateUrl: "./admin-orgunit-detail.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-detail/shared-abstract-detail.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminOrgunitDetailRoutable extends SharedAbstractDetailRoutable<OrganizationalUnitExtended, AdminOrganizationalUnitStateModel> {
  @Select((state: LocalStateModel) => StoreUtil.isLoadingState(state.admin.admin_organizationalUnit.admin_organizationalUnit_submissionPolicy)) isLoadingSubmissionPoliciesObs: Observable<boolean>;
  @Select((state: LocalStateModel) => StoreUtil.isLoadingState(state.admin.admin_organizationalUnit.admin_organizationalUnit_preservationPolicy)) isLoadingPreservationPoliciesObs: Observable<boolean>;
  @Select((state: LocalStateModel) => state.admin.admin_organizationalUnit.admin_organizationalUnit_submissionPolicy.selected) selectedSubmissionPoliciesObs: Observable<SubmissionPolicy[]>;
  @Select((state: LocalStateModel) => state.admin.admin_organizationalUnit.admin_organizationalUnit_preservationPolicy.selected) selectedPreservationPoliciesObs: Observable<PreservationPolicy[]>;
  @Select((state: LocalStateModel) => state.shared.shared_submissionPolicy.list) listSubmissionPoliciesObs: Observable<SubmissionPolicy[]>;
  @Select((state: LocalStateModel) => state.shared.shared_preservationPolicy.list) listPreservationPoliciesObs: Observable<PreservationPolicy[]>;

  readonly KEY_PARAM_NAME: string = "name";
  readonly KEY_DELETE_BUTTON: string = TRANSLATE("admin.organizationalUnit.delete");
  readonly KEY_EDIT_BUTTON: string = TRANSLATE("admin.organizationalUnit.edit");

  constructor(protected store: Store,
              protected route: ActivatedRoute,
              public dialog: MatDialog) {
    super(store, route, dialog, LocalStateEnum.admin_organizationalUnit, adminOrgUnitActionNameSpace, LocalStateEnum.admin);
  }

  getSubResourceWithParentId(id: string): void {
    this.store.dispatch(new AdminOrgUnitSubmissionPolicyAction.GetAll(id));
    this.store.dispatch(new AdminOrgUnitPreservationPolicyAction.GetAll(id));
  }
}
