import {ChangeDetectionStrategy, Component,} from "@angular/core";
import {adminOrgUnitActionNameSpace} from "@admin/orgunit/stores/admin-organizational-unit.action";
import {AdminOrganizationalUnitStateModel} from "@admin/orgunit/stores/admin-organizational-unit.state";
import {OrganizationalUnitExtended} from "@deposit/models/organizational-unit-extended.model";
import {PreservationPolicy, SubmissionPolicy,} from "@app/generated-api";
import {SharedAbstractCreateRoutable} from "@shared/components/routables/shared-abstract-create/shared-abstract-create.routable";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {LocalStateModel} from "@shared/models/local-state.model";
import {Select, Store,} from "@ngxs/store";
import {Observable} from "rxjs";

@Component({
  selector: "dlcm-admin-orgunit-create-routable",
  templateUrl: "./admin-orgunit-create.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-create/shared-abstract-create.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminOrgunitCreateRoutable extends SharedAbstractCreateRoutable<OrganizationalUnitExtended, AdminOrganizationalUnitStateModel> {
  @Select((state: LocalStateModel) => state.shared.shared_submissionPolicy.list) listSubmissionPoliciesObs: Observable<SubmissionPolicy[]>;
  @Select((state: LocalStateModel) => state.shared.shared_preservationPolicy.list) listPreservationPoliciesObs: Observable<PreservationPolicy[]>;

  constructor(protected store: Store) {
    super(store, LocalStateEnum.admin_organizationalUnit, adminOrgUnitActionNameSpace, LocalStateEnum.admin);
  }
}
